<?php
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL);
ini_set('display_errors', '0');

require __DIR__ . '/vendor/autoload.php';

// =========================
// تنظیمات
// =========================
$OPENAI_API_KEY = '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';
$ASSISTANT_ID   = 'asst_UmEBZ0LPpIWBB4Jyu68DVMNH';

$client = OpenAI::client($OPENAI_API_KEY);

// =========================
// 1. دریافت فایل صوتی
// =========================
if (!isset($_FILES['audio'])) {
    echo json_encode(['error' => 'No audio file uploaded'], JSON_UNESCAPED_UNICODE);
    exit;
}

if ($_FILES['audio']['error'] !== UPLOAD_ERR_OK) {
    error_log('Upload error code: ' . $_FILES['audio']['error']);
    echo json_encode(['error' => 'Upload error: ' . $_FILES['audio']['error']], JSON_UNESCAPED_UNICODE);
    exit;
}

$tmpPath   = $_FILES['audio']['tmp_name'];
$origName  = $_FILES['audio']['name'];
$fileSize  = $_FILES['audio']['size'];

// بررسی اندازه فایل (حداکثر 25MB)
if ($fileSize > 25 * 1024 * 1024) {
    echo json_encode(['error' => 'File too large (max 25MB)'], JSON_UNESCAPED_UNICODE);
    exit;
}

// تشخیص پسوند
$ext = strtolower(pathinfo($origName, PATHINFO_EXTENSION));
$allowedExts = ['m4a', 'mp3', 'mp4', 'mpeg', 'mpga', 'wav', 'webm', '3gp', 'amr', 'ogg'];

if (!in_array($ext, $allowedExts)) {
    $ext = 'm4a';
}

// ذخیره فایل
$savePath = sys_get_temp_dir() . '/voice_' . uniqid() . '.' . $ext;
if (!move_uploaded_file($tmpPath, $savePath)) {
    if (!copy($tmpPath, $savePath)) {
        echo json_encode(['error' => 'Failed to save file'], JSON_UNESCAPED_UNICODE);
        exit;
    }
}

error_log("Audio saved: $savePath (" . filesize($savePath) . " bytes)");

// =========================
// 2. Speech to Text (Whisper)
// =========================
$userMessage = '';

try {
    $transcription = $client->audio()->transcribe([
        'model' => 'whisper-1',
        'file'  => fopen($savePath, 'r'),
        'language' => 'fa',
    ]);

    $userMessage = trim($transcription->text);
    
    if ($userMessage === '') {
        @unlink($savePath);
        echo json_encode(['error' => 'Empty transcription'], JSON_UNESCAPED_UNICODE);
        exit;
    }

    error_log("Transcription: $userMessage");

} catch (Throwable $e) {
    @unlink($savePath);
    error_log('Whisper error: ' . $e->getMessage());
    echo json_encode(['error' => 'Speech to text failed: ' . $e->getMessage()], JSON_UNESCAPED_UNICODE);
    exit;
}

// حذف فایل ورودی
@unlink($savePath);

// =========================
// 3. Assistant API
// =========================
$assistantReply = '';

try {
    // ایجاد thread
    $thread = $client->threads()->create([]);
    
    if (!isset($thread->id)) {
        throw new Exception('Thread creation failed');
    }
    
    $threadId = $thread->id;
    error_log("Thread created: $threadId");

    // ارسال پیام
    $client->threads()->messages()->create($threadId, [
        'role' => 'user',
        'content' => $userMessage
    ]);

    // اجرای assistant
    $run = $client->threads()->runs()->create($threadId, [
        'assistant_id' => $ASSISTANT_ID,
    ]);

    error_log("Run started: {$run->id}");

    // انتظار برای تکمیل (حداکثر 60 ثانیه)
    $maxWait = 60;
    $startTime = time();
    
    while (true) {
        if (time() - $startTime > $maxWait) {
            throw new Exception('Timeout after 60 seconds');
        }

        $run = $client->threads()->runs()->retrieve($threadId, $run->id);
        
        if ($run->status === 'completed') {
            break;
        }
        
        if (in_array($run->status, ['failed', 'cancelled', 'expired'])) {
            throw new Exception("Run status: {$run->status}");
        }

        usleep(500000); // 0.5 second
    }

    // دریافت پاسخ
    $messages = $client->threads()->messages()->list($threadId, ['limit' => 10]);

    foreach ($messages->data as $msg) {
        if ($msg->role === 'assistant') {
            foreach ($msg->content as $part) {
                if ($part->type === 'text') {
                    $assistantReply = trim($part->text->value);
                    break 2;
                }
            }
        }
    }

    if ($assistantReply === '') {
        throw new Exception('Empty assistant response');
    }

    // نمایش بخشی از پاسخ در لاگ
    $logReply = function_exists('mb_substr') 
        ? mb_substr($assistantReply, 0, 100) 
        : substr($assistantReply, 0, 100);
    error_log("Assistant reply: $logReply" . (strlen($assistantReply) > 100 ? '...' : ''));

} catch (Throwable $e) {
    error_log('Assistant error: ' . $e->getMessage());
    echo json_encode([
        'error' => 'Assistant failed: ' . $e->getMessage(),
        'transcript' => $userMessage
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

// =========================
// 4. Text to Speech
// =========================
// ایجاد پوشه voices اگر وجود نداره
$voicesDir = __DIR__ . '/voices';
if (!is_dir($voicesDir)) {
    mkdir($voicesDir, 0755, true);
}

$voiceFileName = 'voice_reply_' . uniqid() . '.mp3';
$voiceFilePath = $voicesDir . '/' . $voiceFileName;

try {
    // محدود کردن طول متن (حداکثر 4096 کاراکتر)
    if (function_exists('mb_substr')) {
        $ttsText = mb_substr($assistantReply, 0, 4096);
    } else {
        $ttsText = substr($assistantReply, 0, 4096);
    }

    $response = $client->audio()->speech([
        'model' => 'tts-1',
        'voice' => 'alloy',
        'input' => $ttsText,
    ]);

    // Response مستقیماً string است
    $audioContent = (string)$response;
    
    if (empty($audioContent)) {
        throw new Exception("Empty TTS response");
    }

    $bytesWritten = file_put_contents($voiceFilePath, $audioContent);
    
    if ($bytesWritten === false || $bytesWritten === 0) {
        throw new Exception("Failed to save audio file");
    }

    error_log("TTS saved: $voiceFilePath ($bytesWritten bytes)");

} catch (Throwable $e) {
    error_log('TTS error: ' . $e->getMessage());
    echo json_encode([
        'error' => 'TTS failed: ' . $e->getMessage(),
        'transcript' => $userMessage,
        'reply_text' => $assistantReply
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

// =========================
// 5. پاک‌سازی فایل‌های قدیمی
// =========================
try {
    $files = glob($voicesDir . '/voice_reply_*.mp3');
    $now = time();
    foreach ($files as $file) {
        if (is_file($file) && $now - filemtime($file) > 3600) {
            @unlink($file);
        }
    }
} catch (Throwable $e) {
    // Ignore cleanup errors
}

// =========================
// 6. پاسخ نهایی
// =========================
echo json_encode([
    'success' => true,
    'transcript' => $userMessage,
    'reply_text' => $assistantReply,
    'reply_voice' => 'voices/' . $voiceFileName  // مسیر نسبی برای دسترسی
], JSON_UNESCAPED_UNICODE);