<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require __DIR__ . '/vendor/autoload.php';

use OpenAI;

$client = OpenAI::client("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");

$assistantId = "asst_UmEBZ0LPpIWBB4Jyu68DVMNH";
$userMessage  = $_POST['message'] ?? "";

// Create thread
$thread = $client->threads()->create();

// Add user message
$client->threads()->messages()->create($thread->id, [
    'role' => 'user',
    'content' => $userMessage
]);

// Run assistant
$run = $client->threads()->runs()->create($thread->id, [
    'assistant_id' => $assistantId
]);

// ----------------------------------------------------------
// ✔ HANDLE TOOL CALLS (مثل file_search)
// ----------------------------------------------------------

while (true) {

    $run = $client->threads()->runs()->retrieve($thread->id, $run->id);

    if ($run->status === 'completed') {
        break;
    }

    if ($run->status === 'requires_action') {

        foreach ($run->required_action->submit_tool_outputs->tool_calls as $toolCall) {

            $toolId = $toolCall->id;
            $toolName = $toolCall->function->name;
            $args     = json_decode($toolCall->function->arguments, true);

            $output = "";

            // -------------------------
            // 🔍 FILE SEARCH (PDF RULES)
            // -------------------------
            if ($toolName === "file_search") {

                $query = $args["query"] ?? "";

                $results = $client->vectorStores()->search([
                    'vector_store_id' => $args["vector_store_id"],
                    'query' => $query
                ]);

                $content = [];
                foreach ($results->data as $result) {
                    $content[] = $result->chunk->text;
                }

                $output = implode("\n", $content);
            }

            // Submit tool output back to assistant
            $client->threads()->runs()->submitToolOutputs(
                threadId: $thread->id,
                runId:    $run->id,
                request: [
                    'tool_outputs' => [
                        [
                            'tool_call_id' => $toolId,
                            'output'       => $output,
                        ]
                    ]
                ]
            );
        }
    }

    usleep(300000);
}

// ----------------------------------------------------------
// ✔ GET THE ASSISTANT’S FINAL ANSWER
// ----------------------------------------------------------

$messages = $client->threads()->messages()->list($thread->id);

$reply = "خطا: دستیار پاسخی نداد.";

foreach (array_reverse($messages->data) as $msg) {
    if ($msg->role === 'assistant') {
        foreach ($msg->content as $content) {
            if ($content->type === 'text') {
                $reply = $content->text->value;
                break 2;
            }
        }
    }
}

echo json_encode([
    "reply" => $reply
], JSON_UNESCAPED_UNICODE);